/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemWinterGiftLarge
extends ItemBase {
    public ItemWinterGiftLarge() {
        this.group = LycanitesMobs.group;
        this.itemName = "wintergiftlarge";
        this.setup();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
        }
        if (!world.field_72995_K) {
            this.open(itemStack, world, player);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void open(ItemStack itemStack, World world, EntityPlayer player) {
        String message = I18n.func_74838_a((String)("item." + this.itemName + ".bad"));
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        if (AssetManager.getSound(this.itemName + "_bad") == null) {
            AssetManager.addSound(this.itemName + "_bad", this.group, "item." + this.itemName + ".bad");
        }
        this.playSound(world, player.func_180425_c(), AssetManager.getSound(this.itemName + "_bad"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        Class[] entityClasses = ObjectLists.getEntites("winter_tricks");
        if (entityClasses == null) {
            return;
        }
        if (entityClasses.length <= 0) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            Class entityClass = entityClasses[player.func_70681_au().nextInt(entityClasses.length)];
            if (entityClass == null) continue;
            Entity entity = null;
            try {
                entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity == null) continue;
            entity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            if (entity instanceof EntityLivingBase) {
                EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
                if (entityCreature.mobInfo.getEntityID().equals("wendigo")) {
                    entityCreature.func_96094_a("Gooderness");
                } else if (entityCreature.mobInfo.getEntityID().equals("jabberwock")) {
                    entityCreature.func_96094_a("Rudolph");
                } else if (entityCreature.mobInfo.getEntityID().equals("ent")) {
                    entityCreature.func_96094_a("Salty Tree");
                } else if (entityCreature.mobInfo.getEntityID().equals("trent")) {
                    entityCreature.func_96094_a("Salty Tree");
                } else if (entityCreature.mobInfo.getEntityID().equals("phantom")) {
                    entityCreature.func_96094_a("Satan Claws");
                } else if (entityCreature.mobInfo.getEntityID().equals("behemoth")) {
                    entityCreature.func_96094_a("Krampus");
                }
            }
            world.func_72838_d(entity);
        }
    }
}

